# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Create a new managed metadata service application
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

$appPoolName = "Managed Metadata Service Application Pool"
$appPoolAccount = "domain\user"
$appName = "Managed Metadata Service"
$dbName = "ManagedMetadata"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Create the Service Application Pool (Alternatively use Get-SPServiceApplicationPool to use an existing one)
$pool = New-SPServiceApplicationPool $appPoolName -Account $appPoolAccount
	
# Create the Managed Metadata Service Application
$mms = New-SPMetadataServiceApplication -Name $appName -ApplicationPool $pool -DatabaseName $dbName

# Create the Managed Metadata Service Application proxy
New-SPMetadataServiceApplicationProxy Name ($appName + " Proxy") -ServiceApplication $mms DefaultProxyGroup

# Start the Managed Metadata Web Service on the local SharePoint server
(Get-SPServer servername).ServiceInstances | Where-Object { $_.TypeName -eq "Managed Metadata Web Service" } | ForEach-Object { $_.Provision() }

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 